/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.profile;

import com.ibm.hsc.auiml.databeans.profile.PIFullSysProfBean;
import com.ibm.hsc.auiml.databeans.profile.PIProfileProcessorActionListener;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.hsc.common.util.AuimlDataBeanAdapter;
import com.ibm.hsc.websm.common.LparUtils;
import com.ibm.hsc.websm.common.ProfileUtils;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOXContainerObj;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class PIProfileProcessorDataBean
extends AuimlDataBeanAdapter {
    private static final String PROFILEMOBJECT = "com.ibm.hsc.websm.profile.ProfileMObject";
    private static final String LPARMOBJECT = "com.ibm.hsc.websm.lpar.LPARMObject";
    private static final String CECMOBJECT = "com.ibm.hsc.websm.cec.CECMObject";
    private static final short DEDICATED = 0;
    private static final short SHARED = 1;
    private static final long LPAR_CAPABLE = Integer.MIN_VALUE;
    private static final long OS400_INTPERF_CAPABLE = 0x40000000L;
    private static final long COD_CAPABLE = 0x20000000L;
    private static final String PROCMODEGROUP_S = "ProfileP03Processing.ProcModeGroup";
    private static final String SHAREDBUTTON_S = "ProfileP03Processing.SharedProcsButton";
    private static final String DEDICATEDBUTTON_S = "ProfileP03Processing.DedicatedProcsButton";
    private static final String CAPPEDBUTTON_S = "Capped";
    private static final String UNCAPPEDBUTTON_S = "Uncapped";
    private static final String WIZARD_DEDICATEDPROCS_S = "ProfileP03Processing2.DesiredProcs";
    private static final String WIZARD_SHAREDPROCUNITS_S = "ProfileP03Processing2.DesiredProcUnits";
    private static final String DEDICATEDPROCS_S = "ProfileP03Processing.DedicatedProcs";
    private static final String SHAREDPROCUNITS_S = "ProfileP03Processing.SharedProcUnits";
    private String m_dedicatedProcsString;
    private String m_sharedProcUnitsString;
    private static final String NOT_ENOUGH_CONFIGURABLE_PROCS = HSCResourceBundleUtil.getMessage("ProfileBundle", "NOT_ENOUGH_CONFIGURABLE_PROCS");
    private static final String DESIRED_PROCS_NOT_IN_RANGE = HSCResourceBundleUtil.getMessage("ProfileBundle", "DESIRED_PROCS_NOT_IN_RANGE");
    private static final String DESIRED_VPROCS_NOT_IN_RANGE = HSCResourceBundleUtil.getMessage("ProfileBundle", "DESIRED_VPROCS_NOT_IN_RANGE");
    private static final String DESIRED_PROC_UNITS_NOT_IN_RANGE = HSCResourceBundleUtil.getMessage("ProfileBundle", "DESIRED_PROC_UNITS_NOT_IN_RANGE");
    private static final String DESIRED_PROCS_TOO_SMALL = HSCResourceBundleUtil.getMessage("ProfileBundle", "DESIRED_PROCS_TOO_SMALL");
    private static final String DESIRED_PROC_UNITS_TOO_BIG_FOR_VPROCS = HSCResourceBundleUtil.getMessage("ProfileBundle", "DESIRED_PROC_UNITS_TOO_BIG_FOR_VPROCS");
    private static final String MIN_PROC_UNITS_TOO_BIG_FOR_MIN_VPROCS = HSCResourceBundleUtil.getMessage("ProfileBundle", "MIN_PROC_UNITS_TOO_BIG_FOR_MIN_VPROCS");
    private static final String MAX_PROC_UNITS_TOO_BIG_FOR_MAX_VPROCS = HSCResourceBundleUtil.getMessage("ProfileBundle", "MAX_PROC_UNITS_TOO_BIG_FOR_MAX_VPROCS");
    private static final String DESIRED_INTERACTIVE_NOT_IN_RANGE = HSCResourceBundleUtil.getMessage("ProfileBundle", "DESIRED_INTERACTIVE_NOT_IN_RANGE");
    private PILPARProfileDataBean m_cimProfileBean;
    private MOXContainerObj m_moxObj;
    private MOClass m_moClass;
    private short m_procPool;
    private short m_sharingMode;
    private short m_uncappedWeight;
    private long m_totalProcUnits;
    private long m_desiredProcUnits;
    private long m_minProcUnits;
    private long m_maxProcUnits;
    private long m_maxOS400ProcUnits;
    private int m_minProcUnitsPerVProc;
    private int m_vprocRatio;
    private int m_virtualProcs;
    private int m_minVirtualProcs;
    private int m_maxVirtualProcs;
    private short m_procMode;
    private int m_minOptimalInteractive;
    private int m_maxOptimalInteractive;
    private int m_desiredInteractive;
    private int m_minInteractive;
    private int m_maxInteractive;
    private int m_desiredProcs;
    private int m_minProcs;
    private int m_maxProcs;
    private int m_maxOS400Procs;
    private boolean m_dedicatedHoard;
    private int m_maxVprocPerLpar = 0;
    private boolean m_interactivePerfCap = false;
    private long m_cecCapability = 0L;
    private boolean m_defaultVirtProcs = true;
    private boolean m_os400ProcCapacityLimited = false;

    public PIProfileProcessorDataBean(MOXContainerObj mOXContainerObj, PICECDataBean pICECDataBean, PILPARProfileDataBean pILPARProfileDataBean, boolean bl) {
        MOXContainerObj mOXContainerObj2;
        String string = mOXContainerObj.getMOClassName();
        if (PROFILEMOBJECT.equals(string)) {
            mOXContainerObj2 = ProfileUtils.getLPARMOXContainerObj(mOXContainerObj);
            this.m_moxObj = LparUtils.getCECMOXContainerObj(mOXContainerObj2);
            this.m_moClass = this.m_moxObj.getMOClass();
            if (IDebug.enabled()) {
                try {
                    System.err.println("    CEC MOClass = " + this.m_moClass.getName());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        } else if (LPARMOBJECT.equals(string)) {
            this.m_moxObj = LparUtils.getCECMOXContainerObj(mOXContainerObj);
            this.m_moClass = this.m_moxObj.getMOClass();
            if (IDebug.enabled()) {
                try {
                    System.err.println("    CEC MOClass = " + this.m_moClass.getName());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        } else if (CECMOBJECT.equals(string)) {
            this.m_moClass = mOXContainerObj.getMOClass();
            this.m_moxObj = mOXContainerObj;
            if (IDebug.enabled()) {
                try {
                    System.err.println("    CEC MOClass = " + this.m_moClass.getName());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        } else {
            throw new RuntimeException("Expecting CECMObject, LPARMObject, or ProfileMObject, found " + string);
        }
        mOXContainerObj2 = null;
        this.m_cimProfileBean = pILPARProfileDataBean;
        this.m_procPool = 0;
        this.m_sharingMode = 0;
        this.m_uncappedWeight = (short)128;
        this.m_totalProcUnits = pICECDataBean.getConfigurableProcUnits().longValue();
        this.m_maxOS400ProcUnits = pICECDataBean.getMaxI5OSProcUnits().longValue();
        this.m_maxOS400Procs = pICECDataBean.getMaxI5OSProcUnits().intValue();
        this.m_desiredProcUnits = 0L;
        this.m_minProcUnits = 0L;
        this.m_maxProcUnits = 0L;
        this.m_minProcUnitsPerVProc = 0;
        this.m_vprocRatio = 0;
        mOXContainerObj2 = pICECDataBean.getMaxVProcPerLpar();
        if (mOXContainerObj2 != null) {
            this.m_maxVprocPerLpar = mOXContainerObj2.intValue();
        }
        if ((mOXContainerObj2 = pICECDataBean.getMinProcUnitsPerVirtualProc()) != null) {
            this.m_minProcUnitsPerVProc = mOXContainerObj2.intValue();
            this.m_vprocRatio = (int)Math.rint(1.0 / this.procUnitsLongToDouble(this.m_minProcUnitsPerVProc));
            this.m_minProcUnits = this.m_minProcUnitsPerVProc;
            this.m_maxProcUnits = this.m_minProcUnitsPerVProc;
            this.m_desiredProcUnits = this.m_minProcUnitsPerVProc;
        }
        this.m_virtualProcs = 1;
        this.m_minVirtualProcs = 1;
        this.m_maxVirtualProcs = 1;
        this.m_procMode = 0;
        this.m_minOptimalInteractive = 0;
        this.m_maxOptimalInteractive = 0;
        this.m_desiredInteractive = 0;
        this.m_minInteractive = 0;
        this.m_maxInteractive = 0;
        this.m_desiredProcs = 1;
        this.m_minProcs = 1;
        this.m_maxProcs = 1;
        this.m_dedicatedHoard = false;
        this.m_interactivePerfCap = pICECDataBean.isInteractiveHMCManaged();
        this.m_os400ProcCapacityLimited = pICECDataBean.isOS400ProcCapacityLimited();
        if (bl) {
            this.m_dedicatedProcsString = WIZARD_DEDICATEDPROCS_S;
            this.m_sharedProcUnitsString = WIZARD_SHAREDPROCUNITS_S;
        } else {
            this.m_dedicatedProcsString = DEDICATEDPROCS_S;
            this.m_sharedProcUnitsString = SHAREDPROCUNITS_S;
            this.m_defaultVirtProcs = false;
        }
    }

    public void setProcPool(double d) throws IllegalUserDataException {
        this.m_procPool = (short)Math.rint(d);
    }

    public double getProcPool() {
        return this.m_procPool;
    }

    public void setSharingModeGroupSelection(String[] stringArray) throws IllegalUserDataException {
        if (stringArray != null && stringArray.length == 1) {
            this.m_sharingMode = CAPPEDBUTTON_S.equals(stringArray[0]) ? (short)0 : 1;
        }
    }

    public String[] getSharingModeGroupSelection() {
        if (this.m_sharingMode == 0) {
            return new String[]{CAPPEDBUTTON_S};
        }
        return new String[]{UNCAPPEDBUTTON_S};
    }

    public void setUncappedWeight(double d) throws IllegalUserDataException {
        this.m_uncappedWeight = (short)Math.rint(d);
    }

    public double getUncappedWeight() {
        return this.m_uncappedWeight;
    }

    public void setTotalProcUnits(String string) throws IllegalUserDataException {
    }

    public String getTotalProcUnits() {
        return this.procUnitsToString(this.m_totalProcUnits);
    }

    public void setDesiredProcUnits(double d) throws IllegalUserDataException {
        this.m_desiredProcUnits = this.procUnitsDoubleToLong(d);
    }

    public double getDesiredProcUnits() {
        return this.procUnitsLongToDouble(this.m_desiredProcUnits);
    }

    public void setMinProcUnits(double d) throws IllegalUserDataException {
        this.m_minProcUnits = this.procUnitsDoubleToLong(d);
    }

    public double getMinProcUnits() {
        return this.procUnitsLongToDouble(this.m_minProcUnits);
    }

    public void setMaxProcUnits(double d) throws IllegalUserDataException {
        this.m_maxProcUnits = this.procUnitsDoubleToLong(d);
    }

    public double getMaxProcUnits() {
        return this.procUnitsLongToDouble(this.m_maxProcUnits);
    }

    public void setVProcRatio(String string) throws IllegalUserDataException {
    }

    public String getVProcRatio() {
        return this.procUnitsToString(this.m_minProcUnitsPerVProc);
    }

    public void setVirtualProcs(double d) throws IllegalUserDataException {
        this.m_virtualProcs = (int)Math.rint(d);
    }

    public double getVirtualProcs() {
        return this.m_virtualProcs;
    }

    public void setMinVirtualProcs(double d) throws IllegalUserDataException {
        this.m_minVirtualProcs = (int)Math.rint(d);
    }

    public double getMinVirtualProcs() {
        return this.m_minVirtualProcs;
    }

    public void setMaxVirtualProcs(double d) throws IllegalUserDataException {
        this.m_maxVirtualProcs = (int)Math.rint(d);
    }

    public double getMaxVirtualProcs() {
        return this.m_maxVirtualProcs;
    }

    public void setProcModeGroupSelection(String[] stringArray) throws IllegalUserDataException {
        if (stringArray != null && stringArray.length == 1) {
            if (DEDICATEDBUTTON_S.equals(stringArray[0])) {
                this.m_procMode = 0;
            } else if (SHAREDBUTTON_S.equals(stringArray[0])) {
                this.m_procMode = 1;
            }
        }
    }

    public String[] getProcModeGroupSelection() {
        if (this.m_procMode == 0) {
            return new String[]{DEDICATEDBUTTON_S};
        }
        return new String[]{SHAREDBUTTON_S};
    }

    public void setInteractiveDesiredProcessing(String string) throws IllegalUserDataException {
    }

    public String getInteractiveDesiredProcessing() {
        if (this.m_procMode == 0) {
            return "" + this.m_desiredProcs;
        }
        return this.procUnitsToString(this.m_desiredProcUnits);
    }

    public void setOptimalInteractiveRange(String string) throws IllegalUserDataException {
    }

    public String getOptimalInteractiveRange() {
        String string = HSCResourceBundleUtil.getMessage("ProfileBundle", "OPTIMAL_INTERACTIVE_RANGE", "NLS_MESSAGE_NOT_FOUND", new String[]{this.interactiveToString(this.m_minOptimalInteractive), this.interactiveToString(this.m_maxOptimalInteractive)});
        return string;
    }

    public double getMinOptimalInteractiveRange() {
        return (double)this.m_minOptimalInteractive / 100.0;
    }

    public double getMaxOptimalInteractiveRange() {
        return (double)this.m_maxOptimalInteractive / 100.0;
    }

    public void setDesiredInteractive(double d) throws IllegalUserDataException {
        this.m_desiredInteractive = this.interactiveDoubleToInt(d);
    }

    public double getDesiredInteractive() {
        return this.interactiveIntToDouble(this.m_desiredInteractive);
    }

    public void setMinInteractive(double d) throws IllegalUserDataException {
        this.m_minInteractive = this.interactiveDoubleToInt(d);
    }

    public double getMinInteractive() {
        return this.interactiveIntToDouble(this.m_minInteractive);
    }

    public void setMaxInteractive(double d) throws IllegalUserDataException {
        this.m_maxInteractive = this.interactiveDoubleToInt(d);
    }

    public double getMaxInteractive() {
        return this.interactiveIntToDouble(this.m_maxInteractive);
    }

    public void setTotalProcs(String string) throws IllegalUserDataException {
    }

    public String getTotalProcs() {
        return this.procUnitsToProcsString(this.m_totalProcUnits);
    }

    public void setDesiredProcs(double d) throws IllegalUserDataException {
        this.m_desiredProcs = (int)Math.rint(d);
    }

    public double getDesiredProcs() {
        return this.m_desiredProcs;
    }

    public void setMinProcs(double d) throws IllegalUserDataException {
        this.m_minProcs = (int)Math.rint(d);
    }

    public double getMinProcs() {
        return this.m_minProcs;
    }

    public void setMaxProcs(double d) throws IllegalUserDataException {
        this.m_maxProcs = (int)Math.rint(d);
    }

    public double getMaxProcs() {
        return this.m_maxProcs;
    }

    public void setDedicatedHoard(boolean bl) throws IllegalUserDataException {
        this.m_dedicatedHoard = bl;
    }

    public boolean isDedicatedHoard() {
        return this.m_dedicatedHoard;
    }

    public void setDedicatedNormal(boolean bl) throws IllegalUserDataException {
        this.m_dedicatedHoard = !bl;
    }

    public boolean isDedicatedNormal() {
        return !this.m_dedicatedHoard;
    }

    public void setUncapped(boolean bl) throws IllegalUserDataException {
        this.m_sharingMode = bl ? (short)1 : 0;
    }

    public boolean isUncapped() {
        return this.m_sharingMode != 0;
    }

    public void setDefaultVirtProcs(boolean bl) {
        this.m_defaultVirtProcs = bl;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        boolean bl = false;
        UserTaskManager userTaskManager = null;
        userTaskManager = this.getUTM();
        Object[] objectArray = userTaskManager.getDataObjects();
        Object object = null;
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            if (!(object instanceof PIFullSysProfBean)) continue;
            PIFullSysProfBean pIFullSysProfBean = (PIFullSysProfBean)object;
            bl = pIFullSysProfBean.isprofileType();
        }
        if (!bl) {
            this.verifyProc();
            this.verifyInteractive();
        }
    }

    public void verifyProc() throws IllegalUserDataException {
        if (this.m_procMode == 0) {
            this.verifyDedProcs();
        } else {
            this.verifyProcUnits();
            if (!this.m_defaultVirtProcs) {
                this.verifyVirtualProcs();
            }
        }
    }

    public void verifyDedProcs() throws IllegalUserDataException {
        String string;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.m_cimProfileBean.getOsType().shortValue() == 129 && this.m_os400ProcCapacityLimited && this.m_maxProcs > this.m_maxOS400Procs / 100) {
            string = MessageFormat.format(HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "0651"), Integer.toString(this.m_maxOS400Procs / 100));
            stringBuffer.append(string);
            bl = true;
        }
        if ((long)this.m_desiredProcs > this.m_totalProcUnits / 100L) {
            stringBuffer.append(NOT_ENOUGH_CONFIGURABLE_PROCS + "  ");
            bl = true;
        }
        if (this.m_minProcs > this.m_desiredProcs || this.m_desiredProcs > this.m_maxProcs) {
            stringBuffer.append(DESIRED_PROCS_NOT_IN_RANGE + "  ");
            bl = true;
        }
        if (this.m_desiredProcs < 1) {
            stringBuffer.append(DESIRED_PROCS_TOO_SMALL + "  ");
            bl = true;
        }
        if (bl) {
            string = stringBuffer.toString();
            throw new IllegalUserDataException(string);
        }
    }

    public void verifyProcUnits() throws IllegalUserDataException {
        String string;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.m_cimProfileBean.getOsType().shortValue() == 129 && this.m_os400ProcCapacityLimited && this.m_maxProcUnits > this.m_maxOS400ProcUnits) {
            string = MessageFormat.format(HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "0652"), Double.toString((double)this.m_maxOS400ProcUnits / 100.0));
            stringBuffer.append(string);
            bl = true;
        }
        if (this.m_desiredProcUnits > this.m_totalProcUnits) {
            stringBuffer.append(NOT_ENOUGH_CONFIGURABLE_PROCS + "  ");
            bl = true;
        }
        if (this.m_minProcUnits > this.m_desiredProcUnits || this.m_desiredProcUnits > this.m_maxProcUnits) {
            stringBuffer.append(DESIRED_PROC_UNITS_NOT_IN_RANGE + "  ");
            bl = true;
        }
        if (bl) {
            string = stringBuffer.toString();
            throw new IllegalUserDataException(string);
        }
        if (this.m_defaultVirtProcs) {
            if (this.m_cimProfileBean.getOsType().shortValue() == 129 && this.m_sharingMode == 1 && this.m_os400ProcCapacityLimited) {
                this.m_minVirtualProcs = this.m_maxOS400Procs / 100;
                this.m_virtualProcs = this.m_maxOS400Procs / 100;
                this.m_maxVirtualProcs = this.m_maxOS400Procs / 100;
            } else {
                double d = 0.0;
                d = this.getDesiredProcUnits();
                if (d % 1.0 > 0.0) {
                    int n = this.m_virtualProcs = d % 1.0 >= 0.5 ? (int)Math.rint(d) : (int)Math.rint(d) + 1;
                    if (this.m_virtualProcs < 1) {
                        this.m_virtualProcs = 1;
                    }
                } else {
                    this.m_virtualProcs = (int)Math.rint(d);
                }
                if ((d = this.getMinProcUnits()) % 1.0 > 0.0) {
                    int n = this.m_minVirtualProcs = d % 1.0 >= 0.5 ? (int)Math.rint(d) : (int)Math.rint(d) + 1;
                    if (this.m_minVirtualProcs < 1) {
                        this.m_minVirtualProcs = 1;
                    }
                } else {
                    this.m_minVirtualProcs = (int)Math.rint(d);
                }
                d = this.getMaxProcUnits() * (double)this.m_vprocRatio;
                this.m_maxVirtualProcs = (int)Math.floor(d);
                if (this.m_maxVirtualProcs > this.m_maxVprocPerLpar) {
                    this.m_maxVirtualProcs = this.m_maxVprocPerLpar;
                }
            }
        }
    }

    public void verifyVirtualProcs() throws IllegalUserDataException {
        String string;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.m_cimProfileBean.getOsType().shortValue() == 129 && this.m_sharingMode == 1 && this.m_os400ProcCapacityLimited && this.m_maxVirtualProcs * 100 > this.m_maxOS400Procs) {
            string = MessageFormat.format(HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "0653"), Integer.toString(this.m_maxOS400Procs / 100));
            stringBuffer.append(string);
            bl = true;
        }
        if (this.m_minVirtualProcs > this.m_virtualProcs || this.m_virtualProcs > this.m_maxVirtualProcs) {
            stringBuffer.append(DESIRED_VPROCS_NOT_IN_RANGE + "  ");
            bl = true;
        }
        if (this.m_desiredProcUnits > (long)(this.m_virtualProcs * 100)) {
            stringBuffer.append(DESIRED_PROC_UNITS_TOO_BIG_FOR_VPROCS + "  ");
            bl = true;
        }
        if (this.m_minProcUnits > (long)(this.m_minVirtualProcs * 100)) {
            stringBuffer.append(MIN_PROC_UNITS_TOO_BIG_FOR_MIN_VPROCS + "  ");
            bl = true;
        }
        if (this.m_maxProcUnits > (long)(this.m_maxVirtualProcs * 100)) {
            stringBuffer.append(MAX_PROC_UNITS_TOO_BIG_FOR_MAX_VPROCS + "  ");
            bl = true;
        }
        if (this.m_desiredProcUnits * (long)this.m_vprocRatio < (long)(this.m_virtualProcs * 100)) {
            stringBuffer.append(HSCResourceBundleUtil.getMessage("ProfileBundle", "DESIRED_PROC_UNITS_TOO_SMALL_FOR_VPROCS", "NLS_MESSAGE_NOT_FOUND", new String[]{"" + this.m_vprocRatio}) + "  ");
            bl = true;
        }
        if (this.m_minProcUnits * (long)this.m_vprocRatio < (long)(this.m_minVirtualProcs * 100)) {
            stringBuffer.append(HSCResourceBundleUtil.getMessage("ProfileBundle", "MIN_PROC_UNITS_TOO_SMALL_FOR_MIN_VPROCS", "NLS_MESSAGE_NOT_FOUND", new String[]{"" + this.m_vprocRatio}) + "  ");
            bl = true;
        }
        if (this.m_maxProcUnits * (long)this.m_vprocRatio < (long)(this.m_maxVirtualProcs * 100)) {
            stringBuffer.append(HSCResourceBundleUtil.getMessage("ProfileBundle", "MAX_PROC_UNITS_TOO_SMALL_FOR_MAX_VPROCS", "NLS_MESSAGE_NOT_FOUND", new String[]{"" + this.m_vprocRatio}) + "  ");
            bl = true;
        }
        if (bl) {
            string = stringBuffer.toString();
            throw new IllegalUserDataException(string);
        }
    }

    public void verifyInteractive() throws IllegalUserDataException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.m_minInteractive > this.m_desiredInteractive || this.m_desiredInteractive > this.m_maxInteractive) {
            stringBuffer.append(DESIRED_INTERACTIVE_NOT_IN_RANGE);
            bl = true;
        }
        if (bl) {
            String string = stringBuffer.toString();
            throw new IllegalUserDataException(string);
        }
    }

    public void load() {
        short s;
        UnsignedInt8 unsignedInt8;
        UnsignedInt16 unsignedInt16;
        UnsignedInt16 unsignedInt162;
        UnsignedInt16 unsignedInt163;
        UnsignedInt8 unsignedInt82 = this.m_cimProfileBean.getSharingMode();
        UnsignedInt8 unsignedInt83 = this.m_cimProfileBean.getProcType();
        if (unsignedInt83 != null) {
            UnsignedInt16 unsignedInt164;
            short s2 = unsignedInt83.shortValue();
            if (s2 == 255) {
                short s3;
                this.m_procMode = 0;
                if (unsignedInt82 != null && (s3 = unsignedInt82.shortValue()) == 1) {
                    this.m_dedicatedHoard = true;
                }
                if ((unsignedInt164 = this.m_cimProfileBean.getDesiredCpu()) != null) {
                    this.m_desiredProcs = unsignedInt164.intValue();
                }
                if ((unsignedInt163 = this.m_cimProfileBean.getMinCpu()) != null) {
                    this.m_minProcs = unsignedInt163.intValue();
                }
                if ((unsignedInt162 = this.m_cimProfileBean.getMaxCpu()) != null) {
                    this.m_maxProcs = unsignedInt162.intValue();
                }
            } else {
                UnsignedInt16 unsignedInt165;
                UnsignedInt16 unsignedInt166;
                UnsignedInt16 unsignedInt167;
                this.m_procMode = 1;
                this.m_procPool = s2;
                if (unsignedInt82 != null) {
                    this.m_sharingMode = unsignedInt82.shortValue();
                }
                if ((unsignedInt164 = this.m_cimProfileBean.getUncappedWeight()) != null && this.m_sharingMode == 1) {
                    this.m_uncappedWeight = unsignedInt164.shortValue();
                }
                if ((unsignedInt163 = this.m_cimProfileBean.getDesiredProcUnit()) != null) {
                    this.m_desiredProcUnits = unsignedInt163.longValue();
                }
                if ((unsignedInt162 = this.m_cimProfileBean.getMinProcUnit()) != null) {
                    this.m_minProcUnits = unsignedInt162.longValue();
                }
                if ((unsignedInt16 = this.m_cimProfileBean.getMaxProcUnit()) != null) {
                    this.m_maxProcUnits = unsignedInt16.longValue();
                }
                if ((unsignedInt167 = this.m_cimProfileBean.getDesiredCpu()) != null) {
                    this.m_virtualProcs = unsignedInt167.intValue();
                }
                if ((unsignedInt166 = this.m_cimProfileBean.getMinCpu()) != null) {
                    this.m_minVirtualProcs = unsignedInt166.intValue();
                }
                if ((unsignedInt165 = this.m_cimProfileBean.getMaxCpu()) != null) {
                    this.m_maxVirtualProcs = unsignedInt165.intValue();
                }
            }
        } else {
            this.m_procMode = 1;
        }
        if ((unsignedInt8 = this.m_cimProfileBean.getOsType()) != null && (s = unsignedInt8.shortValue()) == 129) {
            unsignedInt163 = this.m_cimProfileBean.getDesiredInteractive();
            if (unsignedInt163 != null) {
                this.m_desiredInteractive = unsignedInt163.intValue();
            }
            if ((unsignedInt162 = this.m_cimProfileBean.getMinInteractive()) != null) {
                this.m_minInteractive = unsignedInt162.intValue();
            }
            if ((unsignedInt16 = this.m_cimProfileBean.getMaxInteractive()) != null) {
                this.m_maxInteractive = unsignedInt16.intValue();
            }
        }
    }

    public void save() {
        if (this.m_procMode == 0) {
            this.m_cimProfileBean.setProcType(new UnsignedInt8(255));
            if (this.m_dedicatedHoard) {
                this.m_cimProfileBean.setSharingMode(new UnsignedInt8(1));
            } else {
                this.m_cimProfileBean.setSharingMode(new UnsignedInt8(0));
            }
            this.m_cimProfileBean.setDesiredCpu(new UnsignedInt16(this.m_desiredProcs));
            this.m_cimProfileBean.setMinCpu(new UnsignedInt16(this.m_minProcs));
            this.m_cimProfileBean.setMaxCpu(new UnsignedInt16(this.m_maxProcs));
            this.m_cimProfileBean.setDesiredProcUnit(null);
            this.m_cimProfileBean.setMinProcUnit(null);
            this.m_cimProfileBean.setMaxProcUnit(null);
            this.m_cimProfileBean.setUncappedWeight(null);
        } else {
            this.m_cimProfileBean.setProcType(new UnsignedInt8(this.m_procPool));
            this.m_cimProfileBean.setSharingMode(new UnsignedInt8(this.m_sharingMode));
            if (this.m_sharingMode == 1) {
                this.m_cimProfileBean.setUncappedWeight(new UnsignedInt8(this.m_uncappedWeight));
            } else {
                this.m_cimProfileBean.setUncappedWeight(new UnsignedInt8(0));
            }
            this.m_cimProfileBean.setDesiredCpu(new UnsignedInt16(this.m_virtualProcs));
            this.m_cimProfileBean.setMinCpu(new UnsignedInt16(this.m_minVirtualProcs));
            this.m_cimProfileBean.setMaxCpu(new UnsignedInt16(this.m_maxVirtualProcs));
            this.m_cimProfileBean.setDesiredProcUnit(new UnsignedInt32(this.m_desiredProcUnits));
            this.m_cimProfileBean.setMinProcUnit(new UnsignedInt32(this.m_minProcUnits));
            this.m_cimProfileBean.setMaxProcUnit(new UnsignedInt32(this.m_maxProcUnits));
        }
        UnsignedInt8 unsignedInt8 = this.m_cimProfileBean.getOsType();
        if (unsignedInt8 != null) {
            short s = unsignedInt8.shortValue();
            if (s == 129) {
                this.m_cimProfileBean.setDesiredInteractive(new UnsignedInt16(this.m_desiredInteractive));
                this.m_cimProfileBean.setMinInteractive(new UnsignedInt16(this.m_minInteractive));
                this.m_cimProfileBean.setMaxInteractive(new UnsignedInt16(this.m_maxInteractive));
            } else {
                this.m_cimProfileBean.setDesiredInteractive(null);
                this.m_cimProfileBean.setMinInteractive(null);
                this.m_cimProfileBean.setMaxInteractive(null);
            }
        } else {
            this.m_cimProfileBean.setDesiredInteractive(null);
            this.m_cimProfileBean.setMinInteractive(null);
            this.m_cimProfileBean.setMaxInteractive(null);
        }
        if (IDebug.enabled()) {
            System.err.println("Processing: " + this.m_cimProfileBean);
        }
    }

    public void storeProcMode(UserTaskManager userTaskManager) {
        try {
            userTaskManager.storeElement(PROCMODEGROUP_S);
        }
        catch (IllegalUserDataException illegalUserDataException) {
            return;
        }
    }

    public void displayAdvancedDialog(UserTaskManager userTaskManager) {
        try {
            this.verifyProcUnits();
            boolean bl = false;
            if (this.m_totalProcUnits / 100L < 1L) {
                bl = true;
            }
            if (bl) {
                this.setSharingModeGroupSelection(new String[]{CAPPEDBUTTON_S});
            }
            AuimlAdapter auimlAdapter = new AuimlAdapter("com.ibm.hsc.auiml.databeans.profile.LparProfWizard", "SharedSharingModePanel", new DataBean[]{this}, userTaskManager);
            if (bl) {
                System.out.println("utm = " + userTaskManager);
                System.out.println("utm.getUserContect() = " + userTaskManager.getUserContext());
                UserTaskManager userTaskManager2 = auimlAdapter.getUserTaskManager();
                System.out.println("utm = " + userTaskManager2);
                System.out.println("utm.getUserContect() = " + userTaskManager2.getUserContext());
                userTaskManager2.setEnabled(UNCAPPEDBUTTON_S, false);
            }
            auimlAdapter.setAttribute("MaxVirtualProcs", 29, Integer.toString(this.m_maxVprocPerLpar));
            auimlAdapter.addTaskActionListener(new PIProfileProcessorActionListener(this));
            auimlAdapter.showIt();
        }
        catch (Throwable throwable) {
            new TaskMessage(userTaskManager, throwable.getMessage(), 1).invoke();
        }
    }

    public void updateInteractiveProcUnits(UserTaskManager userTaskManager) {
        block11: {
            UnsignedInt32 unsignedInt32 = null;
            try {
                if (this.m_procMode == 0) {
                    unsignedInt32 = new UnsignedInt32((long)(this.m_desiredProcs * 100));
                } else {
                    System.err.println("m_desiredProcUnits..." + this.m_desiredProcUnits);
                    unsignedInt32 = new UnsignedInt32(this.m_desiredProcUnits * 100L);
                }
            }
            catch (IllegalUserDataException illegalUserDataException) {
                illegalUserDataException.printStackTrace();
                return;
            }
            if (this.m_moClass != null) {
                Object[] objectArray = null;
                UnsignedInt16[] unsignedInt16Array = null;
                objectArray = new Object[]{this.m_moxObj, unsignedInt32};
                try {
                    unsignedInt16Array = (UnsignedInt16[])this.m_moClass.invokeStaticMethod("queryOptimalInteractiveRange", objectArray);
                    if (unsignedInt16Array != null) {
                        for (int i = 0; i < unsignedInt16Array.length; ++i) {
                            System.err.println("range [" + i + "] = " + unsignedInt16Array[i]);
                        }
                        if (unsignedInt16Array[0] != null && unsignedInt16Array[1] != null) {
                            this.m_minOptimalInteractive = unsignedInt16Array[0].intValue();
                            this.m_maxOptimalInteractive = unsignedInt16Array[1].intValue();
                        }
                        break block11;
                    }
                    this.m_minOptimalInteractive = 0;
                    this.m_maxOptimalInteractive = 0;
                }
                catch (Exception exception) {
                    System.err.println("Exception caught in updateInteractive...");
                    exception.printStackTrace();
                    this.m_minOptimalInteractive = 0;
                    this.m_maxOptimalInteractive = 0;
                }
            } else {
                System.err.println("updateInteractiveProcUnits(): m_moClass = null!");
            }
        }
    }

    public boolean isInteractivePerfCap() {
        return this.m_interactivePerfCap;
    }

    private int interactiveDoubleToInt(double d) {
        return (int)Math.rint(d * 100.0);
    }

    private double interactiveIntToDouble(int n) {
        return (double)n / 100.0;
    }

    private long procUnitsDoubleToLong(double d) {
        return (long)Math.rint(d * 100.0);
    }

    private double procUnitsLongToDouble(long l) {
        return (double)l / 100.0;
    }

    private String interactiveToString(int n) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format(this.interactiveIntToDouble(n));
    }

    private String procUnitsToString(long l) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format(this.procUnitsLongToDouble(l));
    }

    private String procUnitsToProcsString(long l) {
        return "" + l / 100L;
    }
}

